function [t_prof] = make_prof( n, m );

	t_prof = struct( ...
		'len',			n * m,	...
		'n',			n,	...
		'm',			m,	...
		'bGT',			mod( m, n ) ~= 0,	...
		...
		'IndexIn',		[],	...
		'IndexOut',		[],	...
		...
		'Rotate',		[],	...
		'IndexKT',		[],	...
		...
		'Dft_T',		[]	...
	);

	if t_prof.bGT;
		t_prof.IndexIn   = index_gt_in( n, m );
		t_prof.IndexOut  = index_gt_out( n, m );
	else;
		t_prof.Rotate	 = make_rotate( n, m );
		t_prof.IndexIn   = 1 : n * m;
		t_prof.IndexOut  = index_kt( n, m );
	end;
	
	if n == 1 && m > 1;
		t_prof.Dft_T = make_dft( m );
	end;
	